using System;
using Server;
using Server.Misc;
using Server.Items;
using Server.Spells.Spellweaving;
using Server.Network;

namespace Server.Mobiles
{
	//[CorpseName( "a forest elf corpse" )]
	public class DarkElfMage : BaseCreature
	{
		private DateTime m_NextSpeechTime = DateTime.Now;
		private DateTime m_Summon = DateTime.Now;
		
		public override bool ShowFameTitle{ get{ return false; } }
		public override bool AlwaysMurderer{ get{ return true; } }
		public override int TreasureMapLevel{ get{ return 4; } }
		public override bool CanRummageCorpses{ get{ return true; } }
		public override bool BardImmune { get { return true; } }
		public override bool Unprovokable { get { return true; } }
		public override bool Uncalmable { get { return true; } }
		
		[Constructable]
		public DarkElfMage() : base( AIType.AI_Necromage, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Hue = DarkElf.RandomDarkElfSkinHue;
			SpeechHue = Utility.RandomDyedHue();
			EmoteHue = Utility.RandomNeutralHue();
			
			if ( Female = Utility.RandomBool() )
			{
				Body = 606;
				Name = NameList.RandomName( "dark elf female" );
			}
			else
			{
				Body = 605;
				Name = NameList.RandomName( "dark elf male" );
			}
			// hair, facial hair
			HairItemID = Race.Elf.RandomHair( Female );
			HairHue = DarkElf.RandomDarkElfHairHue;
			Race = Race.Elf;
			Title = "the Dark elf";
			
			SetStr( 306, 400 );
			SetDex( 100, 135 );
			SetInt( 450, 505 );

			SetDamage( 19, 29 );
			SetHits( 751, 795 );
			SetMana( 1450, 1500 );
			
			// 			SetDamageType( ResistanceType.Physical, 100 );

			SetResistance( ResistanceType.Physical, 50, 60 );
			SetResistance( ResistanceType.Fire, 50, 70 );
			SetResistance( ResistanceType.Cold, 60, 65 );
			SetResistance( ResistanceType.Poison, 55, 60 );
			SetResistance( ResistanceType.Energy, 50, 65 );

			SetSkill( SkillName.SpiritSpeak, 80.0, 100.0 );
			SetSkill( SkillName.MagicResist, 80.0, 110.0 );
			SetSkill( SkillName.Swords, 100.0, 130.0 );
			SetSkill( SkillName.Fencing, 100.0, 130.0 );
			SetSkill( SkillName.Macing, 100.0, 130.0 );
			SetSkill( SkillName.Tactics, 100.0, 130.0 );
			SetSkill( SkillName.Wrestling, 100.0, 130.0 );
			SetSkill( SkillName.Anatomy, 100.0, 110.0 );
			SetSkill( SkillName.Necromancy, 80.0, 110.0 );
			SetSkill( SkillName.Parry, 60.0, 90.0 );
			SetSkill( SkillName.Magery, 80.0, 110.0 );
			SetSkill( SkillName.EvalInt, 100.1, 120.0 );
			SetSkill( SkillName.Healing, 70.0, 90.0 );
			SetSkill( SkillName.AnimalTaming, 120.0 );
			SetSkill( SkillName.Meditation, 120.0 );
			SetSkill( SkillName.Spellweaving, 110.1, 120.0 );
			
			// outfit
			int OutfitHue = Utility.RandomMinMax( 1102, 1109 );
			BaseArmor arms = new LeafArms();
			//          arms.Resource = CraftResource.BarbedLeather;
			arms.Movable = false;
			arms.Hue = OutfitHue;
			AddItem( arms );
			if ( this.Female )
			{
				BaseArmor femalechest = new FemaleLeafChest();
				//          femalechest.Resource = CraftResource.BarbedLeather;
				femalechest.Movable = false;
				femalechest.Hue = OutfitHue;
				AddItem( femalechest );
			}
			else
			{
				BaseArmor chest = new LeafChest();
				//          chest.Resource = CraftResource.BarbedLeather;
				chest.Movable = false;
				chest.Hue = OutfitHue;
				AddItem( chest );
			}
			BaseArmor gloves = new LeafGloves();
			//          gloves.Resource = CraftResource.BarbedLeather;
			gloves.Movable = false;
			gloves.Hue = OutfitHue;
			AddItem( gloves );
			BaseArmor gorget = new LeafGorget();
			//          gorget.Resource = CraftResource.BarbedLeather;
			gorget.Movable = false;
			gorget.Hue = OutfitHue;
			AddItem( gorget );
			BaseArmor legs = new LeafLegs();
			//          legs.Resource = CraftResource.BarbedLeather;
			legs.Movable = false;
			legs.Hue = OutfitHue;
			AddItem( legs );
			
			if ( Utility.RandomDouble() < 0.8 )
			{
				Item cloak = new Cloak();
				cloak.Hue = Utility.RandomMinMax( 1902, 1908 );
				
				if ( Utility.RandomDouble() < 0.3 )
				{
					cloak.ItemID = 11013;
					cloak.Movable = false;
				}
				
				AddItem( cloak );
			}
			if ( Utility.RandomDouble() < 0.5 )
			{
				if ( this.Female )
				{
					Item femalerobe = new FemaleElvenRobe();
					femalerobe.Hue = Utility.RandomMinMax( 1902, 1908 );
					femalerobe.Movable = ( Utility.RandomDouble() < 0.005 ) ? true : false;
					AddItem( femalerobe );
				}
				else
				{
					Item robe = new MaleElvenRobe();;
					robe.Hue = Utility.RandomMinMax( 1902, 1908 );
					robe.Movable = ( Utility.RandomDouble() < 0.005 ) ? true : false;
					AddItem( robe );
				}
			}
			if ( Utility.RandomBool() )
			{
				Item belt = new WoodlandBelt( Utility.RandomMinMax( 1902, 1908 ) );
				belt.Movable = false;
				AddItem( belt );
			}
			Item boots = new ElvenBoots( Utility.RandomMinMax( 1902, 1908 ) );
			boots.Movable = ( Utility.RandomDouble() < 0.01 ) ? true : false;
			AddItem( boots );
			
			//talismany
			if ( Utility.RandomDouble() < 0.0001 )
			{
				AddItem( new DridersChitinFragment() );
			}
			else
			{
				Item talisman = new RandomTalisman();
				talisman.Movable = ( Utility.RandomDouble() < 0.05 ) ? true : false;
				AddItem( talisman );
			}

			switch ( Utility.Random( 2 ) )
			{
				case 0:
					switch ( Utility.Random( 4 ))
					{
						case 0:
							{
								BaseWeapon staff = new BlackStaff();
								if ( Utility.RandomBool() )
									staff.Resource = CraftResource.ShadowIron;
								staff.Movable = false;
								AddItem( staff );
							}
							break;
						case 1:
							{
								BaseWeapon staff = new GnarledStaff();
								if ( Utility.RandomBool() )
									staff.Resource = CraftResource.ShadowIron;
								staff.Movable = false;
								AddItem( staff );
							}
							break;
						case 2:
							{
								BaseWeapon staff = new QuarterStaff();
								if ( Utility.RandomBool() )
									staff.Resource = CraftResource.ShadowIron;
								staff.Movable = false;
								AddItem( staff );
							}
							break;
						case 3:
							{
								BaseWeapon staff = new WildStaff();
								if ( Utility.RandomBool() )
									staff.Resource = CraftResource.ShadowIron;
								staff.Movable = false;
								AddItem( staff );
							}
							break;
					}
					break;
				case 1:
					switch ( Utility.Random( 2 ))
					{
						case 0:
							{
								Item wand = new MagicArrowWand();
								if ( Utility.RandomBool() )
									wand.Hue = Utility.RandomMinMax( 1902, 1908 );
								wand.Movable = false;
								AddItem( wand );
							}
							break;
						case 1:
							{
								Item book = new NecromancerSpellbook( (UInt64)0xFFFF );
								if ( Utility.RandomBool() )
									book.Hue = Utility.RandomMinMax( 1902, 1908 );
								book.Movable = false;
								AddItem( book );
							}
							break;
					}
					switch ( Utility.Random( 6 ))
					{
						case 0:
							{
								BaseShield bronzeshield = new BronzeShield();
								bronzeshield.Resource = CraftResource.ShadowIron;
								bronzeshield.Movable = false;
								AddItem( bronzeshield );
							}
							break;
						case 1:
							{
								BaseShield woodenshield = new MetalShield();
								woodenshield.Resource = CraftResource.ShadowIron;
								woodenshield.Movable = false;
								AddItem( woodenshield );
							}
							break;
					}
					break;
			}
			//end outfit
			
			PackItem( Loot.RandomScroll( 1, 4, SpellbookType.Necromancer ) );
			PackNecroReg( 10, 20 );

			Fame = 6000;
			Karma = -7000;
			VirtualArmor = 0;
			
			if ( Utility.RandomDouble() < 0.1 )
				new DarkZostrich().Rider = this;
		}
		
		// 		public override void OnDeath( Container c )
		// 		{
		// 			base.OnDeath( c );

		// 			if ( Utility.RandomDouble() < 0.05 )
		//             c.DropItem( new ForestElvesAmulet() );
		// 		}
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.UltraRich );
			AddLoot( LootPack.HighScrolls, 2 );
		}
		
		public override bool IsNotScaredOfDeath{ get{ return Utility.RandomBool(); } } //neutika pri malem poctu hp - sance 50%
		
		public override void OnMovement( Mobile m, Point3D oldLocation )
		{
			if ( !this.Hidden && DateTime.Now > m_NextSpeechTime && m.InRange( this, 3 ) && m is PlayerMobile )
			{
				m_NextSpeechTime = DateTime.Now + TimeSpan.FromSeconds( Utility.RandomMinMax( 15, 20 ) );
				SayRandom( DarkElf.ElfSay, this );
				this.Move( GetDirectionTo( m.Location ) );
			}
		}
		
		public override void OnDamage( int amount, Mobile from, bool willKill, int typ )
		{
			base.OnDamage( amount, from, willKill, typ );
			
			if ( Utility.RandomDouble() < 0.045 )
			   Ability.FlameSpray( 6, 35, this, false );
		}
		
		public override bool OnBeforeDeath()
		{
			IMount mount = this.Mount;
			if   ( mount != null )
				mount.Rider = null;
			
			if ( mount is Mobile )
			{
				if ( Utility.RandomDouble() > 0.0001 || this.Map == Map.Underworld )
					((Mobile)mount).Delete();
				else
					((Mobile)mount).Combatant = this.Combatant;
			}
			
			return base.OnBeforeDeath();
		}
		
		private static void SayRandom( string[] say, Mobile m )
		{
			m.Say( say[Utility.Random( say.Length )] );
		}
		
		public override void OnActionCombat()
		{
			if ( !this.Hidden && this.Combatant != null && DateTime.Now > m_Summon && Utility.RandomDouble() < 0.3 )
			{
				Mobile target = this.Combatant;
				
				this.Frozen = false;
				this.Say( Utility.RandomBool() ? "Tua amin onna!" : "Ndengina Ho!" ); //help me / kill him

				Map map = this.Map;

				if ( map == null )
					return;

				BaseCreature animal = new SumPoisonElemental();

				bool validLocation = false;
				Point3D loc = this.Location;

				for ( int j = 0; !validLocation && j < 10; ++j )
				{
					int x = X + Utility.Random( 2 ) - 1;
					int y = Y + Utility.Random( 2 ) - 1;
					int z = map.GetAverageZ( x, y );

					if ( validLocation = map.CanFit( x, y, this.Z, 16, false, false ) )
						loc = new Point3D( x, y, Z );
					else if ( validLocation = map.CanFit( x, y, z, 16, false, false ) )
						loc = new Point3D( x, y, z );
				}

				animal.Team = this.Team;
				animal.Hue = Utility.RandomMinMax( 1902, 1908 );
				animal.Kills = 5;
				animal.Name = "a dark spider familiar";
				animal.Body = 28;
				animal.BaseSoundID = 0x388;
				animal.SetDamage( 20, 30 );
				animal.SetResistance( ResistanceType.Poison, 100 );
				animal.MoveToWorld( loc, map );
				animal.Combatant = target;

				m_Summon = DateTime.Now + TimeSpan.FromSeconds( Utility.RandomMinMax( 20, 45 ) );
			}
			base.OnActionCombat();
		}
		
		public DarkElfMage( Serial serial ) : base( serial )
		{
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();
		}
	}
}
